/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter;

import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.ClientCommandHandler;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import mcjty.rftoolsutility.modules.teleporter.items.porter.AdvancedChargedPorterItem;
import mcjty.rftoolsutility.modules.teleporter.items.teleportprobe.TeleportProbeItem;
import mcjty.rftoolsutility.modules.teleporter.network.PacketTargetsReady;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;

public class PorterTools {
    public static void clearTarget(Player player, int index) {
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (heldItem.m_41619_()) {
            return;
        }
        CompoundTag tagCompound = heldItem.m_41783_();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.m_128441_("target" + index)) {
            int id = tagCompound.m_128451_("target" + index);
            if (tagCompound.m_128441_("target") && tagCompound.m_128451_("target") == id) {
                tagCompound.m_128473_("target");
            }
            tagCompound.m_128473_("target" + index);
        }
    }

    public static void forceTeleport(Player player, ResourceKey<Level> dimension, BlockPos pos) {
        boolean probeInOffHand;
        boolean probeInMainHand = !player.m_21205_().m_41619_() && player.m_21205_().m_41720_() instanceof TeleportProbeItem;
        boolean bl = probeInOffHand = !player.m_21206_().m_41619_() && player.m_21206_().m_41720_() instanceof TeleportProbeItem;
        if (!probeInMainHand && !probeInOffHand) {
            return;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        ResourceKey currentId = player.m_20193_().m_46472_();
        if (!currentId.equals(dimension)) {
            TeleportationTools.teleportToDimension((Player)player, dimension, (double)((double)x + 0.5), (double)(y + 1), (double)((double)z + 0.5));
        } else {
            player.m_6021_((double)x + 0.5, (double)y + 1.5, (double)z + 0.5);
        }
    }

    public static void cycleDestination(Player player, boolean next) {
        ItemStack stack = player.m_21205_();
        PorterTools.cycleDestination(player, next, stack);
    }

    public static void cycleDestination(Player player, boolean next, ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof AdvancedChargedPorterItem) {
            int tgt;
            CompoundTag tagCompound = stack.m_41783_();
            if (tagCompound == null) {
                return;
            }
            TeleportDestinations destinations = TeleportDestinations.get(player.m_20193_());
            int curtarget = tagCompound.m_128451_("target");
            int donext = 0;
            for (int i = 0; i < 16 && (donext = PorterTools.checkTarget(player, tagCompound, destinations, curtarget, donext, tgt = next ? i % 8 : (16 - i) % 8)) != 2; ++i) {
            }
        }
    }

    private static int checkTarget(Player playerEntity, CompoundTag tagCompound, TeleportDestinations destinations, int curtarget, int donext, int tgt) {
        TeleportDestination destination;
        int target;
        GlobalPos gc;
        if (tagCompound.m_128441_("target" + tgt) && (gc = destinations.getCoordinateForId(target = tagCompound.m_128451_("target" + tgt))) != null && (destination = destinations.getDestination(gc)) != null) {
            if (donext == 1) {
                String name = destination.getName() + " (dimension " + destination.getDimension().m_135782_().m_135815_() + ")";
                tagCompound.m_128405_("target", target);
                TextComponent component = new TextComponent(ChatFormatting.GREEN + "Target: " + ChatFormatting.WHITE + name);
                if (playerEntity != null) {
                    playerEntity.m_5661_((Component)component, false);
                }
                donext = 2;
            } else if (target == curtarget) {
                donext = 1;
            }
        }
        return donext;
    }

    public static void returnDestinationInfo(Player player, int receiverId) {
        Level world = player.m_20193_();
        TeleportDestinations destinations = TeleportDestinations.get(world);
        String name = TeleportDestinations.getDestinationName(destinations, receiverId);
        RFToolsUtilityMessages.sendToClient(player, "returnDestinationInfo", TypedMap.builder().put(ClientCommandHandler.PARAM_ID, (Object)receiverId).put(ClientCommandHandler.PARAM_NAME, (Object)name));
    }

    public static void setTarget(Player player, int target) {
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (heldItem.m_41619_()) {
            return;
        }
        CompoundTag tagCompound = heldItem.m_41783_();
        if (tagCompound == null) {
            return;
        }
        tagCompound.m_128405_("target", target);
    }

    public static void returnTargets(Player player) {
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (heldItem.m_41619_()) {
            return;
        }
        CompoundTag tagCompound = heldItem.m_41783_();
        int target = -1;
        int[] targets = new int[8];
        String[] names = new String[8];
        TeleportDestinations destinations = TeleportDestinations.get(player.m_20193_());
        if (tagCompound != null) {
            target = tagCompound.m_128441_("target") ? tagCompound.m_128451_("target") : -1;
            for (i = 0; i < 8; ++i) {
                names[i] = "";
                if (tagCompound.m_128441_("target" + i)) {
                    TeleportDestination destination;
                    targets[i] = tagCompound.m_128451_("target" + i);
                    GlobalPos gc = destinations.getCoordinateForId(targets[i]);
                    if (gc == null || (destination = destinations.getDestination(gc)) == null) continue;
                    names[i] = destination.getName() + " (dimension " + destination.getDimension().m_135782_().m_135815_() + ")";
                    continue;
                }
                targets[i] = -1;
            }
        } else {
            for (i = 0; i < 8; ++i) {
                targets[i] = -1;
                names[i] = "";
            }
        }
        PacketTargetsReady msg = new PacketTargetsReady(target, targets, names);
        RFToolsUtilityMessages.INSTANCE.sendTo((Object)msg, ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

